<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\BackupService;

class BackupCleanupCommand extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'backup:cleanup 
                            {--days=30 : Delete backups older than this many days}
                            {--force : Force cleanup without confirmation}';

    /**
     * The console command description.
     */
    protected $description = 'Cleanup old backup files';

    /**
     * Execute the console command.
     */
    public function handle(BackupService $backupService): int
    {
        $days = (int) $this->option('days');
        $force = $this->option('force');

        if ($days < 1) {
            $this->error('Days must be at least 1');
            return 1;
        }

        $this->info("This will delete all backups older than {$days} days.");

        if (!$force && !$this->confirm('Do you want to continue?')) {
            $this->info('Cleanup cancelled.');
            return 0;
        }

        try {
            $deletedCount = $backupService->cleanupOldBackups($days);
            
            $this->info("Cleanup completed! Deleted {$deletedCount} old backup(s).");
            return 0;
        } catch (\Exception $e) {
            $this->error("Cleanup failed: " . $e->getMessage());
            return 1;
        }
    }
}