<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\BackupService;

class BackupCreateCommand extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'backup:create 
                            {type : The backup type (database, files, full)}
                            {--description= : Optional description for the backup}';

    /**
     * The console command description.
     */
    protected $description = 'Create a new backup';

    /**
     * Execute the console command.
     */
    public function handle(BackupService $backupService): int
    {
        $type = $this->argument('type');
        $description = $this->option('description');

        if (!in_array($type, ['database', 'files', 'full'])) {
            $this->error('Invalid backup type. Must be: database, files, or full');
            return 1;
        }

        $this->info("Creating {$type} backup...");

        try {
            $backup = $backupService->createBackup($type, $description);
            
            $this->info("Backup created successfully!");
            $this->table(
                ['ID', 'Name', 'Type', 'Status'],
                [[$backup->id, $backup->name, $backup->type, $backup->status]]
            );

            return 0;
        } catch (\Exception $e) {
            $this->error("Backup failed: " . $e->getMessage());
            return 1;
        }
    }
}