<?php

namespace App\Facades;

use Illuminate\Support\Facades\Facade;

/**
 * @method static \App\Models\Backup createBackup(string $type, string $description = null, int $userId = null)
 * @method static void restoreBackup(\App\Models\Backup $backup)
 * @method static array getDiskSpaceInfo()
 * @method static array getBackupStats()
 * @method static int cleanupOldBackups(int $days)
 * @method static bool validateBackupFile(string $filePath)
 * @method static array checkSystemRequirements()
 * 
 * @see \App\Services\BackupService
 */
class BackupFacade extends Facade
{
    /**
     * Get the registered name of the component.
     */
    protected static function getFacadeAccessor(): string
    {
        return 'backup.service';
    }
}