<?php
namespace App\Helpers;

class LanguageHelper {
    public static function getLanguages() {
        $languages = [];
        foreach (glob(resource_path('lang/*.json')) as $filename) {
            $content = json_decode(file_get_contents($filename), true);
            $languages[] = [
                'code' => $content['Language Code'],
                'name' => $content['Language Name'],
                'icon' => $content['Language Icon'],
                'order' => $content['Lang Order'],
                'direction' => $content['Language Direction'] ?? 'ltr'
            ];
        }
        usort($languages, function($a, $b) {
            return $a['order'] <=> $b['order'];
        });
        return $languages;
    }
    public function showView() {
        $languages = LanguageHelper::getLanguages();
        return view('layout.header', compact('languages'));
    }
}
