<?php

if (!function_exists('s__')) {
    /**
     * Secondary domain translation helper
     */
    function s__($key, $locale = null)
    {
        // Session'ı direkt oku, yoksa default tr
        if (!$locale) {
            $locale = session('secondary_locale');
            if (!$locale) {
                $locale = 'tr';
                session(['secondary_locale' => 'tr']);
            }
        }
        
        // Desteklenen dilleri kontrol et
        $supportedLocales = ['tr', 'en', 'ru', 'ar'];
        if (!in_array($locale, $supportedLocales)) {
            $locale = 'tr';
        }
        
        $filePath = base_path('resources/lang/secondary/' . $locale . '.json');
        
        if (file_exists($filePath)) {
            $translations = json_decode(file_get_contents($filePath), true);
            $result = $translations[$key] ?? $key;
            
           
            
            return $result;
        }
        
        \Log::info('s__ File Not Found', [
            'key' => $key,
            'locale' => $locale,
            'file_path' => $filePath
        ]);
        
        return $key;
    }
}

if (!function_exists('secondary_locale')) {
    /**
     * Get current secondary locale
     */
    function secondary_locale()
    {
        return session('secondary_locale', 'tr');
    }
}

if (!function_exists('secondary_languages')) {
    /**
     * Get available secondary languages
     */
    function secondary_languages()
    {
        $controller = app(\App\Http\Controllers\GorevSitesi\SecondaryLanguageController::class);
        return $controller->getAvailableLanguages();
    }
}