<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class UserHelper
{
    /**
     * Mevcut giriş yapmış kullanıcıyı döndürür
     * Cache kullanarak performansı artırır
     */
    public static function getCurrentUser()
    {
        if (!Auth::check()) {
            return null;
        }

        $userId = Auth::id();
        
        // Cache'den kullanıcı bilgisini al, yoksa veritabanından çek
        return Cache::remember("user_{$userId}", 300, function () {
            return Auth::user()->fresh(); // Fresh ile güncel veriyi al
        });
    }

    /**
     * Kullanıcı cache'ini temizler
     */
    public static function clearUserCache($userId = null)
    {
        $userId = $userId ?? Auth::id();
        if ($userId) {
            Cache::forget("user_{$userId}");
        }
    }

    /**
     * Kullanıcı bilgilerini günceller ve cache'i yeniler
     */
    public static function refreshCurrentUser()
    {
        if (Auth::check()) {
            self::clearUserCache();
            return self::getCurrentUser();
        }
        return null;
    }
}