<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Password;

class AuthController extends Controller
{
    // Register user
    public function register(Request $request)
    {
        //  dd($request->all());
        $messages = [
            'email.unique' => __('The email has already been taken.'),
            'phone.unique' => __('The phone number has already been taken.'),
            'username.unique' => __('The username has already been taken.'),
            'gender.required' => __('Please select your gender.'),
            'password.min' => __('The password must be at least :min characters.'),
        ];
        $validatedData = $request->validate([
            'username' => 'required|string|max:255|unique:users',
            'account_holder' => 'required|string|max:190',
            'email' => 'required|string|email|max:255|unique:users',
            'phone' => 'required|string|max:12|unique:users',
            'password' => 'required|string|min:8|confirmed',
            'gender' => 'required|string|max:10',
            'country_id' => 'required|max:30',
            'city_id' => 'required|max:30'
        ], $messages);

        $user = User::create([
            'username' => $validatedData['username'],
            'account_holder' => $validatedData['account_holder'],
            'email' => $validatedData['email'],
            'phone' => $validatedData['phone'],
            'password' => Hash::make($validatedData['password']),
            'gender' => $validatedData['gender'],
            'country_id' => $validatedData['country_id'],
            'city_id' => $validatedData['city_id'],
            'account_info' => 'Kullanıcı',
            'membership_type' => 2,
            'ip' => $request->ip()
        ]);

        Auth::login($user);

        return redirect('login')->with('success', __('Registration successful!'));
    }

    public function sendPasswordResetLink(Request $request)
    {
        $request->validate(['email' => 'required|email']);

        $status = Password::sendResetLink(
            $request->only('email')
        );

        return $status === Password::RESET_LINK_SENT
            ? back()->with(['status' => __($status)])
            : back()->withErrors(['email' => __($status)]);
    }
}
