<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\City;
class CityController extends Controller
{


public function getCitiesByCountry($countryCode)
{
    // Find the country by phone code (which is stored in 'code' field)
    $country = \App\Models\Country::where('code', $countryCode)->first();
    
    if (!$country) {
        return response()->json([
            'success' => false,
            'cities' => [],
            'message' => 'Country not found with code: ' . $countryCode
        ]);
    }
    
    $cities = City::where('country_id', $country->code)
                  ->orderBy('name')
                  ->get(['id', 'name']);

    return response()->json([
        'success' => true,
        'cities' => $cities,
        'country' => $country->name,
        'debug' => [
            'country_code' => $countryCode,
            'country_id' => $country->id,
            'cities_count' => $cities->count()
        ]
    ]);
}
}