<?php

namespace App\Http\Controllers\GorevSitesi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{
    public function index()
    {
        return view('gorevsitesi.account.dashboard');
    }

    public function profile()
    {
        return view('gorevsitesi.account.profile');
    }

    public function updateProfile(Request $request)
    {
        $request->validate([
            'account_holder' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . auth()->id(),
            'phone' => 'required|string|max:20',
            'iban' => 'nullable|string|max:34',
            'bank_name' => 'nullable|string|max:255',
        ]);

        $user = auth()->user();
        $user->update([
            'account_holder' => $request->account_holder,
            'email' => $request->email,
            'phone' => $request->phone,
            'iban' => $request->iban,
            'bank_name' => $request->bank_name,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Profil bilgileriniz başarıyla güncellendi.'
        ]);
    }

    public function updatePassword(Request $request)
    {
        $request->validate([
            'current_password' => 'required',
            'new_password' => 'required|min:8|confirmed',
        ]);

        $user = auth()->user();

        if (!Hash::check($request->current_password, $user->password)) {
            return response()->json([
                'success' => false,
                'message' => 'Mevcut şifreniz yanlış.'
            ], 422);
        }

        $user->update([
            'password' => Hash::make($request->new_password)
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Şifreniz başarıyla güncellendi.'
        ]);
    }
}
