<?php

namespace App\Http\Controllers\GorevSitesi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use Illuminate\Support\Facades\Auth;

class CartController extends Controller
{
    public function index()
    {
        return view('gorevsitesi.cart.index');
    }

    public function add(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
            'quantity' => 'required|integer|min:1'
        ]);

        $product = Product::findOrFail($request->product_id);
        
        if (!$product->canBePurchased($request->quantity)) {
            return response()->json([
                'success' => false,
                'message' => 'Bu ürün için istenen miktar satın alınamaz.'
            ], 400);
        }

        // Cart will be managed via JavaScript/localStorage for now
        return response()->json([
            'success' => true,
            'message' => 'Ürün sepete eklendi.',
            'product' => [
                'id' => $product->id,
                'name' => $product->product_name,
                'price' => $product->price,
                'image' => $product->image_url,
                'quantity' => $request->quantity,
                'max_quantity' => $product->max_quantity,
                'min_quantity' => $product->min_quantity
            ]
        ]);
    }

    public function remove(Request $request)
    {
        $request->validate([
            'product_id' => 'required|integer'
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Ürün sepetten kaldırıldı.'
        ]);
    }

    public function update(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
            'quantity' => 'required|integer|min:1'
        ]);

        $product = Product::findOrFail($request->product_id);
        
        if (!$product->canBePurchased($request->quantity)) {
            return response()->json([
                'success' => false,
                'message' => 'Bu ürün için istenen miktar satın alınamaz.'
            ], 400);
        }

        return response()->json([
            'success' => true,
            'message' => 'Sepet güncellendi.'
        ]);
    }

    public function checkout()
    {
        if (!Auth::check()) {
            return redirect()->route('site2.login')
                ->with('info', 'Sipariş vermek için giriş yapmanız gerekiyor.');
        }

        return view('gorevsitesi.cart.checkout');
    }
}