<?php

namespace App\Http\Controllers\GorevSitesi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\OrderController as BaseOrderController;
use App\Models\Order;

class OrderController extends Controller
{
    protected $baseOrderController;

    public function __construct(BaseOrderController $baseOrderController)
    {
        $this->baseOrderController = $baseOrderController;
    }

    public function index(Request $request)
    {
        // Directly get orders from database instead of using JSON response
        $orders = Order::where('user_id', auth()->id())
            ->with('product')
            ->orderBy('created_at', 'desc')
            ->paginate(10);
            
        return view('gorevsitesi.account.orders', compact('orders'));
    }

    public function store(Request $request)
    {
        return $this->baseOrderController->store($request);
    }

    public function show($id)
    {
        // Directly get order from database instead of using JSON response
        $order = Order::where('user_id', auth()->id())
            ->with('product')
            ->findOrFail($id);
            
        return view('gorevsitesi.account.order_detail', compact('order'));
    }

    public function cancel($id)
    {
        return $this->baseOrderController->cancel($id);
    }
}
