<?php

namespace App\Http\Controllers\GorevSitesi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Controllers\ProductController as BaseProductController;
use App\Models\ProductCategory;
use App\Models\Product;
use Illuminate\Support\Facades\Log;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        try {
            // Directly get products from database instead of using base controller
            $products = Product::with('category')
                ->where('status', 1)
                ->orderBy('created_at', 'desc')
                ->get();
                
            $categories = ProductCategory::where('status', 1)->get();

            // Debug: Check if categories exist
            if ($categories->isEmpty()) {
                // Create a default category if none exist
                $categories = collect([
                    (object) ['id' => 0, 'name' => 'Genel']
                ]);
            }

            // Debug log
            Log::info('ProductController index - Products count: ' . $products->count());
            Log::info('ProductController index - Categories count: ' . $categories->count());

            if ($request->ajax()) {
                return response()->json([
                    'products' => $products,
                    'categories' => $categories
                ]);
            }

            return view('gorevsitesi.products.index', compact('products', 'categories'));
            
        } catch (\Exception $e) {
            // Fallback data
            $products = collect();
            $categories = collect([
                (object) ['id' => 0, 'name' => 'Genel']
            ]);
            
            return view('gorevsitesi.products.index', compact('products', 'categories'));
        }
    }

    public function show($id)
    {
        $product = Product::where('id', $id)->where('status', 1)->firstOrFail();
        $relatedProducts = Product::where('category_id', $product->category_id)
            ->where('id', '!=', $product->id)
            ->where('status', 1)
            ->limit(4)
            ->get();
        
        return view('gorevsitesi.products.show', compact('product', 'relatedProducts'));
    }
}
