<?php

namespace App\Http\Controllers\GorevSitesi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SecondaryLanguageController extends Controller
{
    private $supportedLocales = ['tr', 'en', 'ru', 'ar'];
    private $langPath = 'resources/lang/secondary/';
    
    public function switch($lang)
    {
        // Desteklenen dilleri kontrol et
        if (!in_array($lang, $this->supportedLocales)) {
            $lang = 'tr'; // Varsayılan dil
        }
        
        // Session'a kaydet
        session()->put('secondary_locale', $lang);
        session()->save(); // Zorla kaydet
        
        // Session'ı yeniden başlat
        session()->regenerate(false);
        
        // Debug için
        \Log::info('Secondary Language Switch', [
            'requested_lang' => $lang,
            'session_locale' => session('secondary_locale'),
            'file_exists' => file_exists(base_path($this->langPath . $lang . '.json')),
            'file_path' => base_path($this->langPath . $lang . '.json')
        ]);
        
        return back();
    }
    
    public function trans($key, $locale = null)
    {
        if (!$locale) {
            $locale = session('secondary_locale', 'tr');
        }
        
        // Desteklenen dilleri kontrol et
        if (!in_array($locale, $this->supportedLocales)) {
            $locale = 'tr';
        }
        
        $filePath = base_path($this->langPath . $locale . '.json');
        
       
        
        if (File::exists($filePath)) {
            $translations = json_decode(File::get($filePath), true);
            $result = $translations[$key] ?? $key;
            
            \Log::info('Translation Result', [
                'key' => $key,
                'result' => $result,
                'available_keys' => array_keys($translations)
            ]);
            
            return $result;
        }
        
        return $key;
    }
    
    public function getCurrentLocale()
    {
        return session('secondary_locale', 'tr');
    }
    
    public function getAvailableLanguages()
    {
        return [
            ['code' => 'tr', 'name' => 'Türkçe', 'icon' => 'tr'],
            ['code' => 'en', 'name' => 'English', 'icon' => 'en'],
            ['code' => 'ru', 'name' => 'Русский', 'icon' => 'ru'],
            ['code' => 'ar', 'name' => 'العربية', 'icon' => 'ar'],
        ];
    }
} 