<?php
namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MemberController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();

        $search = $request->input('search');

        $query = User::select(
            'users.*',
            'cities.name as CityName',
            'countries.name as CountryName'
        )
        ->leftJoin('cities', 'cities.id', '=', 'users.city_id')
        ->leftJoin('countries', 'countries.code', '=', 'users.country_id')
        ->where('users.user_type', '!=', 1);

        if ($search) {
            $query->where(function ($query) use ($search) {
                $query->where('users.account_holder', 'like', "%{$search}%")
                      ->orWhere('users.username', 'like', "%{$search}%")
                      ->orWhere('users.email', 'like', "%{$search}%")
                      ->orWhere('users.phone', 'like', "%{$search}%")
                      ->orWhere('cities.name', 'like', "%{$search}%")
                      ->orWhere('countries.name', 'like', "%{$search}%");
            });
        }

        $members = $query->paginate(10);

        return view('members.index', compact('members', 'user'));
    }

    public function deleteMember(Request $request)
    {
        $user = User::find($request->id);
        if ($user) {
            $user->deleted = 1;
            $user->deletion_reason = $request->reason; // Silme nedeni kaydediliyor
            $user->save();
            return response()->json(['success' => true]);
        }
        return response()->json(['success' => false]);
    }

    public function banMember(Request $request)
    {
        $user = User::find($request->id);
        if ($user) {
            $user->banned = 1;
            $user->ban_reason = $request->reason; // Yasaklama nedeni kaydediliyor
            $user->save();
            return response()->json(['success' => true]);
        }
        return response()->json(['success' => false]);
    }

    public function unbanMember(Request $request)
    {
        $user = User::find($request->id);
        if ($user) {
            $user->banned = 0;
            $user->ban_reason = null;
            $user->save();
            return response()->json(['success' => true]);
        }
        return response()->json(['success' => false]);
    }

    public function getMembersAjax(Request $request)
    {
        $search = $request->input('search');
        $page = $request->input('page', 1);
        $perPage = $request->input('per_page', 10);

        $query = User::select(
            'users.*',
            'cities.name as CityName',
            'countries.name as CountryName'
        )
        ->leftJoin('cities', 'cities.id', '=', 'users.city_id')
        ->leftJoin('countries', 'countries.code', '=', 'users.country_id')
        ->where('users.user_type', '!=', 1);

        if ($search) {
            $query->where(function ($query) use ($search) {
                $query->where('users.account_holder', 'like', "%{$search}%")
                      ->orWhere('users.username', 'like', "%{$search}%")
                      ->orWhere('users.email', 'like', "%{$search}%")
                      ->orWhere('users.phone', 'like', "%{$search}%")
                      ->orWhere('cities.name', 'like', "%{$search}%")
                      ->orWhere('countries.name', 'like', "%{$search}%");
            });
        }

        $members = $query->paginate($perPage, ['*'], 'page', $page);

        return response()->json([
            'success' => true,
            'data' => $members->items(),
            'pagination' => [
                'current_page' => $members->currentPage(),
                'last_page' => $members->lastPage(),
                'per_page' => $members->perPage(),
                'total' => $members->total(),
                'from' => $members->firstItem(),
                'to' => $members->lastItem()
            ]
        ]);
    }

    public function getMemberDetails(Request $request)
    {
        $user = User::select(
            'users.*',
            'cities.name as CityName',
            'countries.name as CountryName'
        )
        ->leftJoin('cities', 'cities.id', '=', 'users.city_id')
        ->leftJoin('countries', 'countries.code', '=', 'users.country_id')
        ->find($request->id);

        if ($user) {
            return response()->json(['success' => true, 'user' => $user]);
        }
        return response()->json(['success' => false]);
    }

}
