<?php

namespace App\Http\Helpers;

use App\Models\Setting;
use Illuminate\Support\Facades\Log;

class RecaptchaHelperFallback
{
    /**
     * cURL ile reCAPTCHA doğrulaması (fallback)
     */
    public static function verify($recaptchaResponse)
    {
        try {
            $settings = Setting::first();
            
            // reCAPTCHA aktif değilse doğrulama geç
            if (!$settings || !$settings->recaptcha_enabled) {
                return true;
            }
            
            // Secret key yoksa hata
            if (empty($settings->recaptcha_secret_key)) {
                Log::warning('reCAPTCHA secret key not found');
                return false;
            }
            
            // reCAPTCHA response yoksa hata
            if (empty($recaptchaResponse)) {
                return false;
            }
            
            // cURL ile doğrulama
            $postData = http_build_query([
                'secret' => $settings->recaptcha_secret_key,
                'response' => $recaptchaResponse,
                'remoteip' => request()->ip()
            ]);
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://www.google.com/recaptcha/api/siteverify');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // SSL doğrulamasını devre dışı bırak
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);
            
            if ($error) {
                Log::error('cURL error in reCAPTCHA verification: ' . $error);
                return false;
            }
            
            if ($httpCode !== 200) {
                Log::error('HTTP error in reCAPTCHA verification: ' . $httpCode);
                return false;
            }
            
            $result = json_decode($response, true);
            
            Log::info('reCAPTCHA verification result (cURL)', [
                'success' => $result['success'] ?? false,
                'error_codes' => $result['error-codes'] ?? [],
                'ip' => request()->ip()
            ]);
            
            return $result['success'] ?? false;
            
        } catch (\Exception $e) {
            Log::error('reCAPTCHA verification error (cURL): ' . $e->getMessage());
            return false;
        }
    }
}