<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    /**
     * Yetkisiz isteklerde hangi login sayfasına yönleneceğini belirler.
     */
    protected function redirectTo($request): ?string
    {
        if ($request->expectsJson()) {
            return null;
        }

        // İkincil domain tespiti
        $secondary = parse_url(config('app.secondary_url'), PHP_URL_HOST) ?: config('app.secondary_url');
        $host = $request->getHost();

        // SC domainindeysek SC login'e
        if ($secondary && (strcasecmp($host, $secondary) === 0)) {
            return route('site2.login');
        }

        // Aksi halde primary login
        return route('login');
    }
}
