<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class BackupMiddleware
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Admin kontrolü isAdmin middleware'i tarafından yapılıyor
        // Burada sadece backup-specific kontroller yapıyoruz

        // Check if backup functionality is enabled (optional setting)
        $settings = app('settings');
        if (isset($settings['backup_enabled']) && !$settings['backup_enabled']) {
            abort(503, 'Backup functionality is currently disabled.');
        }

        // Check disk space before allowing backup operations
        if ($request->isMethod('post') && $request->route()->getName() === 'admin.backups.create') {
            $backupPath = storage_path('app/backups');
            if (file_exists($backupPath)) {
                $freeSpace = disk_free_space($backupPath);
                $minRequiredSpace = 1024 * 1024 * 1024; // 1GB minimum

                if ($freeSpace < $minRequiredSpace) {
                    return response()->json([
                        'success' => false,
                        'message' => __('Insufficient disk space for backup operation.')
                    ], 507);
                }
            }
        }

        return $next($request);
    }
}