<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckUserType
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Kullanıcının oturum açmış ve user_type'ının 1 olup olmadığını kontrol et
        if (Auth::check() && Auth::user()->user_type == 1) {
            return $next($request);
        }

        // Eğer user_type 1 değilse veya oturum açmamışsa, ana sayfaya yönlendirin veya bir hata mesajı gösterin
        return redirect('/')->with('error', 'Bu sayfaya erişim izniniz yok.');
    }
}
