<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class IsAdmin
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && (Auth::user()->user_type == 1 || Auth::user()->membership_type == 1)) {
            return $next($request);
        }

        // AJAX istekleri için JSON response döndür
        if ($request->expectsJson()) {
            return response()->json([
                'success' => false,
                'message' => 'Bu işlem için yetkiniz yok.'
            ], 403);
        }

        return redirect('/home')->with('error', 'Bu sayfaya erişim yetkiniz yok.');
    }
}
