<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class IsCustomer
{
    /**
     * SC müşteri alanı koruması:
     * membership_type: '3' veya 'customer' kabul.
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('site2.login')
                ->withErrors(['auth' => __('Please login to continue.')]);
        }

        $user = Auth::user();

        // Bazı veritabanlarında numeric/string olabiliyor; normalize ediyoruz
        $type = (string) ($user->membership_type ?? '');

        $isCustomer = in_array($type, ['3', 'customer'], true);

        if (!$isCustomer) {
            // SC için müşteri olmayanı dışarı al
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect()->route('site2.login')
                ->withErrors(['auth' => __('Your account is not allowed to access customer area.')]);
        }

        return $next($request);
    }
}
