<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class IsNotCustomer
{
    /**
     * Primary site koruması:
     * Customer kullanıcıların (membership_type: '3' veya 'customer') girişini engeller.
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            return redirect()->route('login')
                ->withErrors(['auth' => __('Please login to continue.')]);
        }

        $user = Auth::user();

        // membership_type kontrolü
        $membershipType = (string) ($user->membership_type ?? '');
        $isCustomer = in_array($membershipType, ['3', 'customer'], true);

        if ($isCustomer) {
            // Customer kullanıcıyı primary site'den çıkar
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect()->route('login')
                ->withErrors(['auth' => __('Customer accounts cannot access this area. Please use the customer portal.')]);
        }

        return $next($request);
    }
}