<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Giriş yapılmışsa doğru dashboard’a yönlendir.
     */
    public function handle($request, Closure $next, ...$guards)
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                $secondary = parse_url(config('app.secondary_url'), PHP_URL_HOST) ?: config('app.secondary_url');
                $host = $request->getHost();

                // SC domainindeysek SC dashboard
                if ($secondary && (strcasecmp($host, $secondary) === 0)) {
                    return redirect()->route('site2.account.dashboard');
                }

                // Primary dashboard
                return redirect()->route('dashboard');
            }
        }

        return $next($request);
    }
}
