<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class TuneSessionForDomain
{
public function handle($request, Closure $next)
{
    $host = $request->getHost(); // gorevsaati.com.tr / gorevsitesi.com.tr
    $cookieName = 'app_session_' . str_replace('.', '_', $host);

    config([
        'session.domain' => null, // kök domain set etmiyoruz
        'session.cookie' => $cookieName,
        'session.secure' => $request->isSecure(),
        'session.same_site' => 'lax', // cross-domain yapmıyorsak
    ]);

    return $next($request);
}
}
