<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class UpdateUserOnlineStatus
{
    public function handle($request, Closure $next)
    {
        if (Auth::check()) {
            $expiresAt = now()->addMinutes(5);
            $onlineUsers = Cache::get('online-users', []);
            if (!in_array(Auth::id(), $onlineUsers)) {
                $onlineUsers[] = Auth::id();
                Cache::put('online-users', $onlineUsers, $expiresAt);
            }
        }

        return $next($request);
    }
}