<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BalanceLog extends Model
{
    protected $table = 'balanceLog';

    protected $fillable = [
        // Mevcut kolonlar
        'userId',
        'TaskId',
        'balance',
        'balance_before',
        'balance_after',
        'added_user',
        'description',
        'type',
        'status',
        
        // Yeni migration ile eklenen kolonlar
        'user_id',
        'amount',
        'operation_type',
        'reference_type',
        'reference_id',
        'payment_method',
        'receipt_path',
        'card_info',
        'approved_by',
        'approved_at',
        'rejected_by',
        'rejected_at',
        'rejection_reason',
    ];

    protected $casts = [
        'balance'            => 'decimal:2',
        'balance_before'     => 'decimal:2',
        'balance_after'      => 'decimal:2',
        'amount'             => 'decimal:2',
        'created_at'         => 'datetime',
        'updated_at'         => 'datetime',
        'approved_at'        => 'datetime',
        'rejected_at'        => 'datetime',
        'card_info'          => 'array',
    ];

    // İlişkiler

    // CamelCase userId ile ilişki
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function rejectedBy()
    {
        return $this->belongsTo(User::class, 'rejected_by');
    }

    // Snake case user_id ile ilişki (isteğe bağlı kullanabilirsiniz)
    public function userSnake()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function task()
    {
        return $this->belongsTo(Task::class, 'TaskId');
    }

    public function addedByUser()
    {
        return $this->belongsTo(User::class, 'added_user');
    }
}