<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    protected $table = 'cities'; 
    protected $fillable = ['name', 'country_id'];
    
    protected $casts = [
        'country_id' => 'integer'
    ]; 

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'code');
    }
}