<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    protected $table = 'countries'; 

    protected $fillable = ['name', 'code'];
    
    protected $casts = [
        'code' => 'integer'
    ];

    public function cities()
    {
        return $this->hasMany(City::class, 'country_id', 'code');
    }
}