<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'type',
        'status',
        'expires_at',
        'link',
        'read_at',
        'user_id'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'expires_at' => 'datetime',
        'read_at' => 'datetime',
        'status' => 'integer'
    ];

    // Relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}