<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SocialPlatform extends Model
{
    protected $table = 'socialplatforms';
    protected $fillable = ['platform', 'icon', 'description', 'status'];

    // İlişkiler
    public function tasks()
    {
        return $this->hasMany(Task::class, 'category_id');
    }

    public function socialMediaAccounts()
    {
        return $this->hasMany(SocialMediaAccount::class, 'platform_id');
    }

    public function taskProofs()
    {
        return $this->hasMany(TaskProof::class, 'category_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
