<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Task extends Model
{
    protected $table = 'tasks';
    protected $fillable = [
        'name', 'link', 'description', 'category_id', 'image', 'reward', 'limit',
        'count_proof', 'user_limit', 'type', 'watch_time', 'country_id', 'user_id',
        'city', 'gender', 'button_text', 'proof_number', 'daily_limit', 'pin',
        'gcode', 'status', 'visibilty', 'isComplated', 'created_by', 'created_at',
        'updated_by', 'updated_at'
    ];

    // İlişkiler
    public function proofs()
    {
        return $this->hasMany(TaskProof::class, 'TaskId');
    }

    public function taskProofs()
    {
        return $this->hasMany(TaskProof::class, 'TaskId');
    }

    public function socialPlatform()
    {
        return $this->belongsTo(SocialPlatform::class, 'category_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'code');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city');
    }

    // Many-to-many ilişki (kullanıcılar bu görevi yapabilir)
    public function participants()
    {
        return $this->belongsToMany(User::class, 'task_user')
            ->using(TaskUser::class)
            ->withPivot('watched_time', 'is_completed')
            ->withTimestamps();
    }
}