<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TaskProof extends Model
{
    protected $table = 'TaskProof';
    public $timestamps = true;
    protected $fillable = ['UserId', 'TaskId', 'Description', 'Status', 'Reason', 'created_at', 'updated_at'];

    public function images()
    {
        return $this->hasMany(TaskProofFile::class, 'proofId');
    }

    public function task()
    {
        return $this->belongsTo(Task::class, 'TaskId', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'UserId');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }

    public function socialPlatform()
    {
        return $this->belongsTo(SocialPlatform::class, 'category_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function files()
    {
        return $this->hasMany(TaskProofFile::class, 'proofId');
    }
}
