<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'amount',
        'type',
        'description',
        'operation_type',
        'reference_type',
        'reference_id',
        'balance_before',
        'balance_after'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'balance_before' => 'decimal:2',
        'balance_after' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Helper method for creating transaction logs
    public static function createLog($userId, $amount, $type, $description, $operationType = 'credit', $referenceType = null, $referenceId = null)
    {
        $user = User::find($userId);
        $balanceBefore = $user->balance;
        
        if ($operationType === 'debit') {
            $user->balance -= $amount;
        } else {
            $user->balance += $amount;
        }
        
        $user->save();
        
        return self::create([
            'user_id' => $userId,
            'amount' => $amount,
            'type' => $type,
            'description' => $description,
            'operation_type' => $operationType,
            'reference_type' => $referenceType,
            'reference_id' => $referenceId,
            'balance_before' => $balanceBefore,
            'balance_after' => $user->balance
        ]);
    }
}