<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WatchCompletion extends Model
{
    use HasFactory;

    protected $fillable = [
        'watch_task_id',
        'user_id',
        'watched_duration',
        'earned_amount',
        'is_completed',
        'started_at',
        'completed_at',
        'ip_address',
        'user_agent'
    ];

    protected $casts = [
        'earned_amount' => 'decimal:2',
        'is_completed' => 'boolean',
        'started_at' => 'datetime',
        'completed_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // İlişkiler
    public function watchTask()
    {
        return $this->belongsTo(WatchTask::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // İzleme yüzdesi
    public function getWatchPercentageAttribute()
    {
        if ($this->watchTask && $this->watchTask->watch_duration > 0) {
            return min(100, ($this->watched_duration / $this->watchTask->watch_duration) * 100);
        }
        return 0;
    }

    // İzleme tamamlandı mı?
    public function isWatchCompleted()
    {
        return $this->watchTask && $this->watched_duration >= $this->watchTask->watch_duration;
    }
}