<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebsiteVisitProofFile extends Model
{
    protected $table = 'website_visit_proof_files';
    
    protected $fillable = [
        'proof_id',
        'file_name',
        'file_path',
        'file_type',
        'file_size'
    ];

    // Relationships
    public function proof()
    {
        return $this->belongsTo(WebsiteVisitProof::class, 'proof_id');
    }

    // Helper methods
    public function getFullPath()
    {
        return public_path('assets/images/websiteVisitProofs/' . $this->file_name);
    }

    public function getUrl()
    {
        return asset('assets/images/websiteVisitProofs/' . $this->file_name);
    }
}