<?php

namespace App\Policies;

use App\Models\Announcement;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class AnnouncementPolicy
{
    use HandlesAuthorization;

    public function viewAny(User $user)
    {
        return true; // All authenticated users can view announcements
    }

    public function view(User $user, Announcement $announcement)
    {
        // Admin can view all
        if ($user->user_type == 1) {
            return true;
        }
        
        // User can view if announcement is for them
        return $announcement->canBeSeenByUser($user->id);
    }

    public function create(User $user)
    {
        return $user->user_type == 1; // Only admins can create
    }

    public function update(User $user, Announcement $announcement)
    {
        return $user->user_type == 1; // Only admins can update
    }

    public function delete(User $user, Announcement $announcement)
    {
        return $user->user_type == 1; // Only admins can delete
    }
}