<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Backup;

class BackupPolicy
{
    /**
     * Determine whether the user can view any backups.
     */
    public function viewAny(User $user): bool
    {
        return $user->user_type === 1; // Only admins
    }

    /**
     * Determine whether the user can view the backup.
     */
    public function view(User $user, Backup $backup): bool
    {
        return $user->user_type === 1;
    }

    /**
     * Determine whether the user can create backups.
     */
    public function create(User $user): bool
    {
        return $user->user_type === 1;
    }

    /**
     * Determine whether the user can download the backup.
     */
    public function download(User $user, Backup $backup): bool
    {
        return $user->user_type === 1 && $backup->status === 'completed';
    }

    /**
     * Determine whether the user can restore from backup.
     */
    public function restore(User $user, Backup $backup): bool
    {
        return $user->user_type === 1 && 
               $backup->status === 'completed' && 
               $backup->type === 'database';
    }

    /**
     * Determine whether the user can delete the backup.
     */
    public function delete(User $user, Backup $backup): bool
    {
        return $user->user_type === 1;
    }

    /**
     * Determine whether the user can cleanup old backups.
     */
    public function cleanup(User $user): bool
    {
        return $user->user_type === 1;
    }
}