<?php

namespace App\Policies;

use App\Models\User;
use App\Models\WebsiteVisitTask;
use Illuminate\Auth\Access\HandlesAuthorization;

class WebsiteVisitTaskPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user)
    {
        return $user->isAdmin();
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, WebsiteVisitTask $websiteVisitTask)
    {
        return $user->canViewWebsiteVisitTask($websiteVisitTask);
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user)
    {
        return $user->canManageWebsiteVisitTasks();
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, WebsiteVisitTask $websiteVisitTask)
    {
        return $user->canEditWebsiteVisitTask($websiteVisitTask);
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, WebsiteVisitTask $websiteVisitTask)
    {
        return $user->canDeleteWebsiteVisitTask($websiteVisitTask);
    }
}