<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\SocialPlatform;
use App\Models\Notification;
use App\Helpers\UserHelper;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // NotificationService'i singleton olarak kaydet
        $this->app->singleton(\App\Services\NotificationService::class, function ($app) {
            return new \App\Services\NotificationService();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot()
    {
        // Secondary domain translation helper'ları yükle
        require_once app_path('Helpers/SecondaryTranslationHelper.php');
        
        View::composer(['layouts.header', 'layouts.nav'], function ($view) {
            $platforms = SocialPlatform::where('status', 1)->get();
            $user = UserHelper::getCurrentUser(); // Helper kullanarak kullanıcı bilgisini al
            $userId = auth()->id(); 
          $notifications = Notification::where('status', 1)
                                         ->whereNull('read_at') 
                                         ->orderBy('created_at', 'desc')
                                         ->take(5) 
                                         ->get();
            $unreadCount = Notification::where('status', 1)
                                       ->whereNull('read_at')
                                       ->count(); 
    
            $view->with('platforms', $platforms)
                 ->with('user', $user) // Helper'dan gelen kullanıcı bilgisini view'a gönder
                 ->with('notifications', $notifications)
                 ->with('unreadCount', $unreadCount);
        });
    }
}
