<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\Http\Controllers\GorevSitesi\SecondaryLanguageController;

class SecondaryTranslationServiceProvider extends ServiceProvider
{
    public function register()
    {
        // SecondaryLanguageController'ı singleton olarak kaydet
        $this->app->singleton('secondary.translator', function () {
            return new SecondaryLanguageController();
        });
    }

    public function boot()
    {
        // Global helper fonksiyonları tanımla
        if (!function_exists('s__')) {
            function s__($key, $locale = null) {
                return app('secondary.translator')->trans($key, $locale);
            }
        }

        if (!function_exists('secondary_locale')) {
            function secondary_locale() {
                return app('secondary.translator')->getCurrentLocale();
            }
        }

        if (!function_exists('secondary_languages')) {
            function secondary_languages() {
                return app('secondary.translator')->getAvailableLanguages();
            }
        }

        // Blade directive'leri ekle
        Blade::directive('s', function ($expression) {
            return "<?php echo s__($expression); ?>";
        });
    }
}