<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Cache;
use App\Models\Setting;


class SettingsServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register()
    {
        $this->app->singleton('settings', function ($app) {
            return Cache::remember('settings', 60, function () {
                return Setting::first()->toArray();
            });
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot()
    {
        view()->composer('*', function ($view) {
            $settings = app('settings');
            
          //  \Log::debug('Settings:', $settings);
    
            if (!array_key_exists('site_name', $settings)) {
             //   \Log::error('The site_name key does not exist in the settings array.');
            }
    
            $view->with('settings', $settings);
        });
    }

}

