<?php
namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use App\Helpers\LanguageHelper;
use App\Services\NotificationService;
use App\Models\SocialPlatform;

class ViewServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Tüm view'lara dil verilerini ekle
        View::composer('*', function ($view) {
            $view->with('languages', LanguageHelper::getLanguages());
        });

        // Header için notification ve platform verilerini ekle
        View::composer(['layouts.header', 'layouts.app'], function ($view) {
            $notifications = collect();
            $unreadCount = 0;
            $platforms = collect();

            try {
                // Platform verilerini yükle
                $platforms = \Illuminate\Support\Facades\Cache::remember('active_platforms_header', 600, function () {
                    return SocialPlatform::where('status', 1)
                        ->select('id', 'platform', 'icon', 'description')
                        ->get();
                });

                // Kullanıcı giriş yapmışsa notification verilerini yükle
                if (Auth::check()) {
                    $notificationService = app(NotificationService::class);
                    $notifications = $notificationService->getUserNotifications(Auth::id(), 10);
                    $unreadCount = $notificationService->getUnreadCount(Auth::id());
                }
            } catch (\Exception $e) {
                // Hata durumunda boş veriler kullan
                \Illuminate\Support\Facades\Log::error('ViewServiceProvider notification error: ' . $e->getMessage());
            }

            $view->with([
                'notifications' => $notifications,
                'unreadCount' => $unreadCount,
                'platforms' => $platforms
            ]);
        });
    }
}
