<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

use App\Http\Middleware\UpdateUserOnlineStatus;
use App\Http\Middleware\SetLanguageMiddleware;
use App\Http\Middleware\LanguageMiddleware;
use App\Http\Middleware\IsAdmin;
use App\Http\Middleware\CheckUserType;
use App\Http\Middleware\Authenticate;
use App\Http\Middleware\RedirectIfAuthenticated;
use App\Http\Middleware\ValidateSignature;
use App\Http\Middleware\IsCustomer;
use App\Http\Middleware\BackupMiddleware;
use App\Http\Middleware\TuneSessionForDomain;
use App\Http\Middleware\MultiSiteMiddleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {

        // Global middleware
        $middleware->append([
            UpdateUserOnlineStatus::class,
            TuneSessionForDomain::class,
        ]);

        // Web grubuna: StartSession'dan ÖNCE çalışması için PREPEND
        $middleware->web(prepend: [
            TuneSessionForDomain::class,
        ]);

        // Web grubuna ek
        $middleware->web(append: [
            SetLanguageMiddleware::class,
            LanguageMiddleware::class,
            MultiSiteMiddleware::class,
        ]);

        // Alias'lar (senin orijinal setin)
        $middleware->alias([
            'auth'         => Authenticate::class,
            'guest'        => RedirectIfAuthenticated::class,
            'signed'       => ValidateSignature::class,
            'setlocale'    => SetLanguageMiddleware::class,
            'isAdmin'      => IsAdmin::class,
            'is_admin'     => IsAdmin::class,
            'checkUserType'=> CheckUserType::class,
            'backup'       => BackupMiddleware::class,
            'is_customer'  => IsCustomer::class,
           'is_not_customer' => \App\Http\Middleware\IsNotCustomer::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
