<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Defaults
    |--------------------------------------------------------------------------
    */
    'defaults' => [
        // Primary site varsayılan guard
        'guard' => 'web',
        'passwords' => 'users',
    ],

    /*
    |--------------------------------------------------------------------------
    | Authentication Guards
    |--------------------------------------------------------------------------
    |
    | "web"  -> gorevsaati.com.tr (primary)
    | "site2"-> gorevsitesi.com.tr (secondary / marketplace)
    |
    */
    'guards' => [
        'web' => [
            'driver'   => 'session',
            'provider' => 'users',
        ],

        'site2' => [
            'driver'   => 'session',
            'provider' => 'users',
        ],

        // API kullanıyorsan burada Sanctum/Token guard'larını ekleyebilirsin.
         'api' => [
            'driver' => 'sanctum',
             'provider' => 'users',
         ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Providers
    |--------------------------------------------------------------------------
    |
    | Tek tablo/model (users) üzerinden ilerliyoruz.
    |
    */
    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model'  => App\Models\User::class,
        ],

        // Alternatif (gerekmez):
        // 'users' => [
        //     'driver' => 'database',
        //     'table'  => 'users',
        // ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Resetting Passwords
    |--------------------------------------------------------------------------
    */
    'passwords' => [
        'users' => [
            'provider' => 'users',
            // Laravel 10+ varsayılan reset tablosu:
            'table'    => 'password_reset_tokens',
            'expire'   => 60,   // dakika
            'throttle' => 60,   // dakika
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Confirmation Timeout
    |--------------------------------------------------------------------------
    */
    'password_timeout' => 10800, // 3 saat
];
