<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('recaptcha_site_key', 500)->nullable()->after('currency')->comment('Google reCAPTCHA Site Key');
            $table->string('recaptcha_secret_key', 500)->nullable()->after('recaptcha_site_key')->comment('Google reCAPTCHA Secret Key');
            $table->boolean('recaptcha_enabled')->default(0)->after('recaptcha_secret_key')->comment('reCAPTCHA aktif mi?');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn(['recaptcha_site_key', 'recaptcha_secret_key', 'recaptcha_enabled']);
        });
    }
};