<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('watch_completions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('watch_task_id');
            $table->unsignedBigInteger('user_id');
            $table->integer('watched_duration'); // Gerçek izleme süresi
            $table->decimal('earned_amount', 10, 2);
            $table->boolean('is_completed')->default(false);
            $table->timestamp('started_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->timestamps();
            
            $table->foreign('watch_task_id')->references('id')->on('watch_tasks');
            $table->foreign('user_id')->references('id')->on('users');
            $table->unique(['watch_task_id', 'user_id']); // Bir kullanıcı bir görevi sadece bir kez tamamlayabilir
            $table->index(['user_id', 'is_completed']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('watch_completions');
    }
};