<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // balance_logs tablosu yoksa bu migration'ı atla
        if (!Schema::hasTable('balance_logs')) {
            return;
        }
        
        Schema::table('balance_logs', function (Blueprint $table) {
            if (!Schema::hasColumn('balance_logs', 'operation_type')) {
                $table->enum('operation_type', ['credit', 'debit'])->after('type')->default('credit');
            }
            if (!Schema::hasColumn('balance_logs', 'reference_type')) {
                $table->string('reference_type')->nullable()->after('operation_type');
            }
            if (!Schema::hasColumn('balance_logs', 'reference_id')) {
                $table->unsignedBigInteger('reference_id')->nullable()->after('reference_type');
            }
            if (!Schema::hasColumn('balance_logs', 'balance_before')) {
                $table->decimal('balance_before', 10, 2)->nullable()->after('amount');
            }
        });
        
        // Index'leri ekle (varsa hata vermez)
        try {
            Schema::table('balance_logs', function (Blueprint $table) {
                $table->index(['user_id', 'operation_type']);
                $table->index(['reference_type', 'reference_id']);
            });
        } catch (\Exception $e) {
            // Index zaten varsa devam et
        }
    }

    public function down()
    {
        Schema::table('balance_logs', function (Blueprint $table) {
            $table->dropColumn(['operation_type', 'reference_type', 'reference_id', 'balance_before']);
        });
    }
};