<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('transaction_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->decimal('amount', 10, 2);
            $table->string('type'); // watch_reward, task_reward, website_visit_reward, task_creation_cost, withdrawal_request, etc.
            $table->text('description');
            $table->enum('operation_type', ['credit', 'debit'])->default('credit');
            $table->string('reference_type')->nullable(); // watch_task, task, website_visit, withdrawal
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->decimal('balance_before', 10, 2);
            $table->decimal('balance_after', 10, 2);
            $table->timestamps();
            
            $table->foreign('user_id')->references('id')->on('users');
            $table->index(['user_id', 'operation_type']);
            $table->index(['reference_type', 'reference_id']);
            $table->index(['type', 'created_at']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('transaction_logs');
    }
};