<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique();
            $table->unsignedBigInteger('user_id'); // Match users table: bigint(20) UNSIGNED
            $table->integer('product_id'); // Match products table: int(11) - no unsigned
            $table->string('product_name'); // Snapshot of product name
            $table->decimal('product_price', 10, 2); // Snapshot of product price
            $table->integer('quantity')->default(1);
            $table->decimal('total_amount', 10, 2);
            $table->enum('status', ['pending', 'processing', 'completed', 'cancelled', 'refunded'])->default('pending');
            $table->enum('payment_status', ['pending', 'paid', 'failed', 'refunded'])->default('pending');
            $table->text('product_data')->nullable(); // JSON data of digital product
            $table->text('delivery_data')->nullable(); // JSON data for delivery (codes, links, etc.)
            $table->timestamp('delivered_at')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            
            // Foreign keys - only for users table since it has proper UNSIGNED
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            
            // Index for product_id without foreign key constraint
            $table->index(['user_id', 'status']);
            $table->index(['product_id']);
            $table->index(['order_number']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('orders');
    }
};