<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->tinyInteger('is_digital')->default(1)->after('status');
            $table->integer('stock_quantity')->default(0)->after('is_digital');
            $table->text('digital_content')->nullable()->after('stock_quantity');
            $table->tinyInteger('auto_delivery')->default(1)->after('digital_content');
            $table->text('delivery_instructions')->nullable()->after('auto_delivery');
        });
    }

    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'is_digital',
                'stock_quantity', 
                'digital_content',
                'auto_delivery',
                'delivery_instructions'
            ]);
        });
    }
};