<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('balanceLog', function (Blueprint $table) {
            $table->string('status')->default('completed')->after('type'); // pending, completed, rejected
            $table->string('payment_method')->nullable()->after('status'); // credit_card, bank_transfer
            $table->string('receipt_path')->nullable()->after('payment_method'); // For bank transfer receipts
            $table->json('card_info')->nullable()->after('receipt_path'); // For credit card info (hashed)
            $table->unsignedBigInteger('approved_by')->nullable()->after('card_info'); // Admin who approved
            $table->timestamp('approved_at')->nullable()->after('approved_by'); // Approval timestamp
            $table->unsignedBigInteger('rejected_by')->nullable()->after('approved_at'); // Admin who rejected
            $table->timestamp('rejected_at')->nullable()->after('rejected_by'); // Rejection timestamp
            $table->text('rejection_reason')->nullable()->after('rejected_at'); // Reason for rejection
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('balanceLog', function (Blueprint $table) {
            $table->dropColumn([
                'status', 'payment_method', 'receipt_path', 'card_info',
                'approved_by', 'approved_at', 'rejected_by', 'rejected_at', 'rejection_reason'
            ]);
        });
    }
};